%% Generate an Erdos-Renyi network
clc
clf
hold off

%% undirected ER network with 1000 nodes, no self links and average degree 10
% Create an empty matrix with 1000 nodes
size=1000;
ER=zeros(size);
%calculate the probability that an edge exists
av_degree=10;
p_exists=av_degree/(size-1); %small correction to the probability, not that important
for i = 1:size
    for j=i+1:size %don't test twice! And don't generate self-links.
        if(rand <p_exists) %generate a link with prob p_exists
            ER(i,j) = 1; %update both parts of adjacency matrix.
            ER(j,i)=1;
        end
    end
end
spy(ER) %visualize
set(gca, 'FontSize', 20);
sum(ER(:))/2 %How many edges? Divide by 2 to avoid double counting

%% directed ER network with 1000 nodes and average out degree 10
% Create an empty matrix with 1000 nodes
size=1000;
ER=zeros(size);
%calculate the probability that an edge exists
av_out_degree=10;
p_exists=av_out_degree/size;
for i = 1:size
    for j=1:size %now out links do not equal in links.
        if(rand <p_exists) %generate a link with prob p_exists
            ER(i,j) = 1; %update only one part of adjacency matrix.
        end
    end
end
figure(2)
spy(ER) %visualize
set(gca, 'FontSize', 20);
sum(ER(:)) %How  many edges? No need to divide by 2 in the directed case.